/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.data;

import org.fest.assertions.data.Offset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RgbColor {
    public final int r;
    public final int g;
    public final int b;

    public static RgbColor color(int rgb) {
        return new RgbColor(RgbColor.extract(rgb, 16), RgbColor.extract(rgb, 8), RgbColor.extract(rgb, 0));
    }

    private static int extract(int rgb, int value) {
        return rgb >> value & 0xFF;
    }

    private RgbColor(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public boolean isEqualTo(RgbColor color, Offset<Integer> offset) {
        if (offset == null) {
            throw new NullPointerException("The given offset should not be null");
        }
        if (this.equals(color)) {
            return true;
        }
        if (color == null) {
            return false;
        }
        int offsetValue = (Integer)offset.value;
        if (Math.abs(this.r - color.r) > offsetValue) {
            return false;
        }
        if (Math.abs(this.g - color.g) > offsetValue) {
            return false;
        }
        return Math.abs(this.b - color.b) <= offsetValue;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.r;
        result = 31 * result + this.g;
        result = 31 * result + this.b;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RgbColor other = (RgbColor)obj;
        if (this.r != other.r) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        return this.b == other.b;
    }

    public String toString() {
        return String.format("color[r=%d, g=%d, b=%d]", this.r, this.g, this.b);
    }
}

