/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.Condition;
import org.fest.assertions.error.ShouldBe;
import org.fest.assertions.error.ShouldHave;
import org.fest.assertions.error.ShouldNotBe;
import org.fest.assertions.error.ShouldNotHave;
import org.fest.assertions.internal.Failures;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conditions {
    private static final Conditions INSTANCE = new Conditions();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Conditions instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Conditions() {
    }

    public <T> void assertIs(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (condition.matches(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBe.shouldBe(actual, condition));
    }

    public <T> void assertIsNot(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBe.shouldNotBe(actual, condition));
    }

    public <T> void assertHas(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (condition.matches(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldHave.shouldHave(actual, condition));
    }

    public <T> void assertDoesNotHave(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotHave.shouldNotHave(actual, condition));
    }

    public void assertIsNotNull(Condition<?> condition) {
        if (condition == null) {
            throw new NullPointerException("The condition to evaluate should not be null");
        }
    }
}

