/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.util.Comparator;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.Condition;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.Arrays;
import org.fest.assertions.internal.Conditions;
import org.fest.assertions.internal.Failures;
import org.fest.util.ComparisonStrategy;
import org.fest.util.StandardComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrays {
    private static final ObjectArrays INSTANCE = new ObjectArrays();
    private Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();

    public static ObjectArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    ObjectArrays() {
        this((ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    public ObjectArrays(ComparisonStrategy comparisonStrategy) {
        this.arrays = new Arrays(comparisonStrategy);
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public void assertNullOrEmpty(AssertionInfo info, Object[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, Object[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, Object[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, Object[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, this.failures, actual, expectedSize);
    }

    public void assertHasSameSizeAs(AssertionInfo info, Object[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, this.failures, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info, Object[] actual, Object[] other) {
        this.arrays.assertHasSameSizeAs(info, this.failures, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, Object[] actual, Object value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info, Object[] actual, Object value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsSequence(AssertionInfo info, Object[] actual, Object[] sequence) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence);
    }

    public void assertDoesNotContain(AssertionInfo info, Object[] actual, Object[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, Object[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, Object[] actual, Object[] sequence) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info, Object[] actual, Object[] sequence) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence);
    }

    public void assertContainsNull(AssertionInfo info, Object[] actual) {
        this.arrays.assertContainsNull(info, this.failures, actual);
    }

    public void assertDoesNotContainNull(AssertionInfo info, Object[] actual) {
        this.arrays.assertDoesNotContainNull(info, this.failures, actual);
    }

    public <E> void assertAre(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertAre(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertAreNot(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertAreNot(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertHave(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertHave(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertDoNotHave(AssertionInfo info, E[] actual, Condition<? super E> condition) {
        this.arrays.assertHaveNot(info, this.failures, this.conditions, actual, condition);
    }

    public <E> void assertAreAtLeast(AssertionInfo info, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreAtLeast(info, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertAreNotAtLeast(AssertionInfo info, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreNotAtLeast(info, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertAreAtMost(AssertionInfo info, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreAtMost(info, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertAreNotAtMost(AssertionInfo info, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreNotAtMost(info, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertAreExactly(AssertionInfo info, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreExactly(info, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertAreNotExactly(AssertionInfo info, E[] actual, int n, Condition<? super E> condition) {
        this.arrays.assertAreNotExactly(info, this.failures, this.conditions, actual, n, condition);
    }

    public <E> void assertHaveAtLeast(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveAtLeast(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertDoNotHaveAtLeast(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertDoNotHaveAtLeast(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHaveAtMost(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveAtMost(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertDoNotHaveAtMost(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertDoNotHaveAtMost(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertHaveExactly(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertHaveExactly(info, this.failures, this.conditions, actual, times, condition);
    }

    public <E> void assertDoNotHaveExactly(AssertionInfo info, E[] actual, int times, Condition<? super E> condition) {
        this.arrays.assertDoNotHaveExactly(info, this.failures, this.conditions, actual, times, condition);
    }

    public void assertIsSorted(AssertionInfo info, Object[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public <E> void assertIsSortedAccordingToComparator(AssertionInfo info, E[] actual, Comparator<? super E> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }

    public <E> void assertContainsAll(AssertionInfo info, E[] actual, Iterable<? extends E> other) {
        this.arrays.assertcontainsAll(info, this.failures, actual, other);
    }
}

