/*
 * Decompiled with CFR 0.152.
 */
package de.xam.velocity;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.xydra.annotations.Template;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.utils.CookieUtils;
import org.xydra.restless.utils.SharedHtmlUtils;

public class ReflectiveHttpRequestContextEntry {
    private static Logger log = LoggerFactory.getLogger(ReflectiveHttpRequestContextEntry.class);
    private final HttpServletRequest req;

    public ReflectiveHttpRequestContextEntry(HttpServletRequest req) {
        this.req = req;
    }

    @Template(value="value of given parameter")
    public String get(String parameterName) {
        return this.getParameter(parameterName);
    }

    public String getCookie(String cookieKey) {
        return CookieUtils.getCookie((HttpServletRequest)this.req, (String)cookieKey);
    }

    public String getKeysCall() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Enumeration enumeration = this.req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String parameterName = (String)enumeration.nextElement();
            List<String> parameterValues = Arrays.asList(this.req.getParameterValues(parameterName));
            paramMap.put(parameterName, SharedHtmlUtils.toOrderedList(parameterValues));
        }
        return SharedHtmlUtils.toDefinitionList(paramMap);
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public String getParameter(String parameterName) {
        String[] rawValues = this.req.getParameterValues(parameterName);
        if (rawValues == null || rawValues.length == 0) {
            return "";
        }
        List<String> parameterValues = Arrays.asList(rawValues);
        if (parameterValues.size() > 1) {
            log.warn("More than one value set for paramter '" + parameterName + "': " + parameterValues);
        }
        return parameterValues.get(0);
    }

    public String getRequest() {
        HashMap<String, String> callMap = new HashMap<String, String>();
        callMap.put("url", this.req.getRequestURI());
        return SharedHtmlUtils.toDefinitionList(callMap);
    }
}

