/*
 * Decompiled with CFR 0.152.
 */
package de.xam.velocity;

import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.xydra.log.api.Logger;
import org.xydra.log.spi.ILoggerFactorySPI;

public class Velocity2XydraLogger
implements LogChute {
    private final Logger xydraLogger;

    public Velocity2XydraLogger(ILoggerFactorySPI loggerFactory) {
        this.xydraLogger = loggerFactory.getWrappedLogger("org.apache.velocity.runtime.log.Log", Velocity2XydraLogger.class.getName());
    }

    public void init(RuntimeServices rs) throws Exception {
    }

    public boolean isLevelEnabled(int level) {
        switch (level) {
            case 0: {
                return this.xydraLogger.isDebugEnabled();
            }
            case 3: {
                return this.xydraLogger.isErrorEnabled();
            }
            case 1: {
                return this.xydraLogger.isInfoEnabled();
            }
            case -1: {
                return this.xydraLogger.isTraceEnabled();
            }
            case 2: {
                return this.xydraLogger.isWarnEnabled();
            }
        }
        throw new IllegalArgumentException("level " + level + " is not a valid log level");
    }

    public void log(int level, String msg) {
        switch (level) {
            case 0: {
                this.xydraLogger.debug(msg);
                break;
            }
            case 3: {
                this.xydraLogger.error(msg);
                break;
            }
            case 1: {
                this.xydraLogger.info(msg);
                break;
            }
            case -1: {
                this.xydraLogger.trace(msg);
                break;
            }
            case 2: {
                this.xydraLogger.warn(msg);
                break;
            }
            default: {
                throw new IllegalArgumentException("level " + level + " is not a valid log level");
            }
        }
    }

    public void log(int level, String msg, Throwable t) {
        if (t.getClass().getName().equals("org.eclipse.jetty.io.EofException")) {
            return;
        }
        switch (level) {
            case 0: {
                this.xydraLogger.debug(msg, t);
                break;
            }
            case 3: {
                this.xydraLogger.error(msg, t);
                break;
            }
            case 1: {
                this.xydraLogger.info(msg, t);
                break;
            }
            case -1: {
                this.xydraLogger.trace(msg, t);
                break;
            }
            case 2: {
                this.xydraLogger.warn(msg, t);
                break;
            }
            default: {
                throw new IllegalArgumentException("level " + level + " is not a valid log level");
            }
        }
    }
}

