/*
 * Decompiled with CFR 0.152.
 */
package de.xam.googleanalytics;

import de.xam.googleanalytics.SharedUtils;
import de.xam.googleanalytics.UrlAndHashUtils;
import de.xam.googleanalytics.UserInfo;

public class UrchinCookie {
    public Utma utma;
    public Utmb utmb;
    public Utmc utmc;
    public Utmv utmv;
    public Utmz utmz;

    public UrchinCookie(UserInfo userinfo) {
        this.utma = new Utma(userinfo.getDomainName(), userinfo.get31BitId(), userinfo.getFirstVisitStartTime(), userinfo.getLastVisitStartTime(), userinfo.getCurrentSessionStartTime(), userinfo.getSessionCount());
        this.utmb = new Utmb(userinfo.getDomainName(), null, userinfo.getCurrentSessionStartTime(), userinfo.getSessionCount());
        this.utmc = new Utmc(userinfo.getDomainName(), null);
        if (userinfo.getVar() != null) {
            this.utmv = new Utmv(userinfo.getVar());
        }
        this.utmz = new Utmz(userinfo.getDomainName(), null);
    }

    public UrchinCookie(String utmaCookie, String utmzCookie) {
        this.utma = new Utma(utmaCookie);
        String domainHash = this.utma.getDomainHash();
        this.utmb = new Utmb(null, domainHash);
        this.utmb.currentSessionStartTime = SharedUtils.getCurrentTimeInSeconds();
        this.utmb.sessionCount = this.utma.sessionCount;
        this.utmc = new Utmc(null, domainHash);
        this.utmv = null;
        this.utmz = new Utmz(utmzCookie);
    }

    public String getCookieString() {
        String utmv;
        String result = "__utma=" + this.utma.toCookieString() + ";";
        result = result + "+__utmb=" + this.utmb.toCookieString() + ";";
        if (this.utmc != null) {
            result = result + "+__utmc=" + this.utmc.toCookieString() + ";";
        }
        result = result + "+__utmz=" + this.utmz.toCookieString() + ";";
        if (this.utmv != null && (utmv = this.utmv.toCookieString()) != null) {
            result = result + ";+__utmv=" + utmv;
        }
        return result;
    }

    private String getUtmx() {
        return null;
    }

    static long parseAsLong(String s) throws IllegalArgumentException {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setCurrentSessionStartTimeToNow() {
        long now;
        this.utma.currentSessionStartTime = now = SharedUtils.getCurrentTimeInSeconds();
        this.utmb.currentSessionStartTime = now;
        assert (this.utmc != null);
    }

    static class Utmz
    extends DomainHashCookie {
        private String campaignCreationTime = "" + UrlAndHashUtils.getCurrentTimeInSeconds();
        private String campaignSessions = "1";
        private String responseCount = "0";
        private String campaignSource = "(direct)";
        private String campaignName = "(direct)";
        private String campaignMedium = "(none)";
        private String campaignTerms = "(none)";
        private String campaignContent = "(none)";

        public Utmz(String domainName, String domainHash, String campaignCreationTime, String campaignSessions, String responseCount, String campaignSource, String campaignName, String campaignMedium, String campaignTerms, String campaignContent) {
            super(domainName, domainHash);
            this.campaignCreationTime = campaignCreationTime;
            this.campaignSessions = campaignSessions;
            this.responseCount = responseCount;
            this.campaignSource = campaignSource;
            this.campaignName = campaignName;
            this.campaignMedium = campaignMedium;
            this.campaignTerms = campaignTerms;
            this.campaignContent = campaignContent;
        }

        public Utmz(String domainName, String domainHash) {
            super(domainName, domainHash);
        }

        public Utmz(String utmzCookie) {
            this.setFromCookieString(utmzCookie);
        }

        public void setFromCookieString(String utmzCookie) throws IllegalArgumentException {
            String[] pipeParts;
            String[] dotParts = utmzCookie.split("\\.");
            if (dotParts.length < 5) {
                throw new IllegalArgumentException("Could not parse into at least five dot-parts: '" + utmzCookie + "'");
            }
            this.domainHash = dotParts[0];
            this.campaignCreationTime = dotParts[1];
            this.campaignSessions = dotParts[2];
            this.responseCount = dotParts[3];
            int processed = dotParts[0].length() + 1 + dotParts[1].length() + 1 + dotParts[2].length() + 1 + dotParts[3].length() + 1;
            String secondPart = utmzCookie.substring(processed);
            for (String p : pipeParts = secondPart.split("\\|")) {
                String[] nameValue = p.split("=");
                if (nameValue.length != 2) continue;
                String name = nameValue[0];
                String value = nameValue[1];
                if (name.equals("utmcsr")) {
                    this.campaignSource = value;
                    continue;
                }
                if (name.equals("utmccn")) {
                    this.campaignName = value;
                    continue;
                }
                if (name.equals("utmcmd")) {
                    this.campaignMedium = value;
                    continue;
                }
                if (name.equals("utmctr")) {
                    this.campaignTerms = value;
                    continue;
                }
                if (!name.equals("utmcct")) continue;
                this.campaignContent = value;
            }
        }

        public String toCookieString() {
            return this.getDomainHash() + "." + this.campaignCreationTime + "." + this.campaignSessions + "." + this.responseCount + "." + "utmcsr=" + this.campaignSource + "|utmccn=" + this.campaignName + "|utmcmd=" + this.campaignMedium + "|utmctr=" + this.campaignTerms + "|utmcct=" + this.campaignContent;
        }
    }

    static class Utmv {
        private final String var;

        public Utmv(String var) {
            this.var = var;
        }

        public String toCookieString() {
            return this.var;
        }
    }

    static class Utmc
    extends DomainHashCookie {
        public Utmc(String domainName, String domainHash) {
            super(domainName, domainHash);
        }

        public String toCookieString() {
            return "" + this.getDomainHash();
        }
    }

    static class Utmb
    extends DomainHashCookie {
        public long currentSessionStartTime;
        public long sessionCount;

        public Utmb(String domainName, String domainHash, long currentSessionStartTime, long sessionCount) {
            super(domainName, domainHash);
            this.currentSessionStartTime = currentSessionStartTime;
            this.sessionCount = sessionCount;
        }

        protected Utmb() {
        }

        public Utmb(String domainName, String domainHash) {
            super(domainName, domainHash);
        }

        public String toCookieString() {
            return this.getDomainHash() + "." + this.sessionCount + "." + "1." + this.currentSessionStartTime;
        }

        public void setFromCookieString(String cookieString) throws IllegalArgumentException {
            String[] dotParts = cookieString.split("\\.");
            if (dotParts.length != 4) {
                throw new IllegalArgumentException("Could not parse '" + cookieString + "' into four dot-separated parts");
            }
            this.domainHash = dotParts[0];
            this.sessionCount = UrchinCookie.parseAsLong(dotParts[1]);
            this.currentSessionStartTime = UrchinCookie.parseAsLong(dotParts[3]);
        }
    }

    static class DomainHashCookie {
        protected String domainName;
        protected String domainHash;

        public DomainHashCookie(String domainName, String domainHash) {
            assert (domainName != null || domainHash != null);
            this.domainName = domainName;
            this.domainHash = domainHash;
        }

        protected DomainHashCookie() {
        }

        public String getDomainHash() {
            if (this.domainHash != null) {
                return this.domainHash;
            }
            assert (this.domainName != null);
            return "" + UrlAndHashUtils.getDomainhash(this.domainName);
        }
    }

    static class Utma
    extends Utmb {
        public long firstVisitStartTime;
        public long lastVisitStartTime;
        public long the31BitId;

        public Utma(String domainName, String domainHash) {
            super(domainName, domainHash);
        }

        public Utma(String cookieString) {
            this.setFromCookieString(cookieString);
        }

        public Utma(String domainName, long the31BitId, long firstVisitStartTime, long lastVisitStartTime, long currentSessionStartTime, long sessionCount) {
            super(domainName, null, currentSessionStartTime, sessionCount);
            this.the31BitId = the31BitId;
            this.firstVisitStartTime = firstVisitStartTime;
            this.lastVisitStartTime = lastVisitStartTime;
        }

        @Override
        public String toCookieString() {
            return this.getDomainHash() + "." + this.the31BitId + "." + this.firstVisitStartTime + "." + this.lastVisitStartTime + "." + this.currentSessionStartTime + "." + this.sessionCount;
        }

        @Override
        public void setFromCookieString(String cookieString) throws IllegalArgumentException {
            String[] dotParts = cookieString.split("\\.");
            if (dotParts.length != 6) {
                throw new IllegalArgumentException("Could not parse '" + cookieString + "' into six dot-separated parts");
            }
            this.domainHash = dotParts[0];
            this.the31BitId = UrchinCookie.parseAsLong(dotParts[1]);
            this.firstVisitStartTime = UrchinCookie.parseAsLong(dotParts[2]);
            this.lastVisitStartTime = UrchinCookie.parseAsLong(dotParts[3]);
            this.currentSessionStartTime = UrchinCookie.parseAsLong(dotParts[4]);
            this.sessionCount = UrchinCookie.parseAsLong(dotParts[5]);
        }
    }
}

