/*
 * Decompiled with CFR 0.152.
 */
package de.xam.googleanalytics;

import de.xam.googleanalytics.FocusPoint;
import de.xam.googleanalytics.GaEvent;
import de.xam.googleanalytics.SharedUtils;
import de.xam.googleanalytics.UrlAndHashUtils;
import java.nio.charset.Charset;
import java.util.Locale;

public class UrchinUrl {
    private static final String TRACKING_URL_Prefix = "http://www.google-analytics.com/__utm.gif";

    public static String toURL(String hostname, FocusPoint focusPoint, String refererURL, String cookieString, String trackingCode, GaEvent gaEvent, int sessionCounter) {
        StringBuffer url = new StringBuffer(TRACKING_URL_Prefix);
        url.append("?utmwv=4.3");
        UrchinUrl.appendIfNotEmpty(url, "utmn", "" + SharedUtils.random31bitInteger(), true);
        UrchinUrl.appendIfNotEmpty(url, "utmhn", hostname, true);
        String charset = Charset.defaultCharset().name();
        UrchinUrl.appendIfNotEmpty(url, "utmcs", charset, true);
        UrchinUrl.appendIfNotEmpty(url, "utmsr", "23x42", true);
        UrchinUrl.appendIfNotEmpty(url, "utmsc", "13-bit", true);
        Locale locale = Locale.getDefault();
        String langcode = locale.getLanguage();
        UrchinUrl.appendIfNotEmpty(url, "utmul", langcode, true);
        UrchinUrl.appendIfNotEmpty(url, "utmje", "1", true);
        UrchinUrl.appendIfNotEmpty(url, "utmfl", "(not set)", true);
        assert (focusPoint.getContentTitle() != null);
        UrchinUrl.appendIfNotEmpty(url, "utmdt", focusPoint.getContentTitle(), false);
        long hid = Math.round(Math.random() * 2.147483647E9);
        UrchinUrl.appendIfNotEmpty(url, "utmhid", "" + hid, true);
        String usedRefererUrl = refererURL;
        if (usedRefererUrl == null) {
            usedRefererUrl = "-";
        }
        UrchinUrl.appendIfNotEmpty(url, "utmr", usedRefererUrl, true);
        assert (focusPoint.getContentURI() != null);
        UrchinUrl.appendIfNotEmpty(url, "utmp", focusPoint.getContentURI(), false);
        UrchinUrl.appendIfNotEmpty(url, "utmac", trackingCode, true);
        UrchinUrl.appendIfNotEmpty(url, "utmcc", cookieString, true);
        if (gaEvent != null) {
            UrchinUrl.appendIfNotEmpty(url, "utmt", "event", true);
            String utmeValue = "5(" + UrlAndHashUtils.urlencode(UrchinUrl.toSafeEventString(gaEvent.category)) + "*" + UrlAndHashUtils.urlencode(UrchinUrl.toSafeEventString(gaEvent.action));
            if (gaEvent.optionalLabel != null) {
                utmeValue = utmeValue + "*" + UrlAndHashUtils.urlencode(UrchinUrl.toSafeEventString(gaEvent.optionalLabel));
            }
            utmeValue = utmeValue + ")";
            if (gaEvent.optionalValue != -1) {
                utmeValue = utmeValue + "(" + gaEvent.optionalValue + ")";
            }
            UrchinUrl.appendIfNotEmpty(url, "utme", utmeValue, false);
        }
        url.append("?utms=" + sessionCounter);
        return url.toString();
    }

    private static String toSafeEventString(String s) {
        return s.replace('(', '[').replace(')', ']').replace('\'', '-').replace('\"', '=');
    }

    private static void appendIfNotEmpty(StringBuffer url, String key, String value, boolean urlEncode) {
        if (value != null) {
            url.append("&");
            url.append(key);
            url.append("=");
            url.append(urlEncode ? UrlAndHashUtils.urlencode(value) : value);
        }
    }
}

