/*
 * Decompiled with CFR 0.152.
 */
package de.xam.googleanalytics;

import de.xam.googleanalytics.SharedUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.xydra.annotations.LicenseApache;

@LicenseApache(copyright="Copyright 2008 Adobe Systems Inc., 2008 Google Inc.", contributors="Zwetan Kjukov <zwetan@gmail.com>. Marc Alcaraz <ekameleon@gmail.com>")
public class UrlAndHashUtils
extends SharedUtils {
    public static int generateHash(String input) {
        int hash = 1;
        int leftMost7 = 0;
        if (input != null && input != "") {
            hash = 0;
            for (int pos = input.length() - 1; pos >= 0; --pos) {
                char current = input.charAt(pos);
                leftMost7 = (hash = (hash << 6 & 0xFFFFFFF) + current + (current << 14)) & 0xFE00000;
                if (leftMost7 == 0) continue;
                hash ^= leftMost7 >> 21;
            }
        }
        return hash;
    }

    public static String urlencode(String raw) {
        try {
            String encoded;
            String niceEncoded = encoded = URLEncoder.encode(raw, "UTF-8");
            niceEncoded = niceEncoded.replace("+", "%20");
            niceEncoded = niceEncoded.replace("%28", "(");
            niceEncoded = niceEncoded.replace("%29", ")");
            return niceEncoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getDomainhash(String domainName) {
        return UrlAndHashUtils.generateHash(domainName);
    }

    public static void main(String[] args) {
        System.out.println(UrlAndHashUtils.urlencode("he he+ho"));
    }

    public static long parseAsLong(String s) throws IllegalArgumentException {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

