/*
 * Decompiled with CFR 0.152.
 */
package de.xam.googleanalytics.tracker;

import de.xam.googleanalytics.UrlAndHashUtils;
import de.xam.googleanalytics.tracker.DomainHashCookie;

class GaUtmbCookie
extends DomainHashCookie {
    public long currentSessionStartTime;
    public long sessionCount;

    public GaUtmbCookie(String domainName, String domainHash, long currentSessionStartTime, long sessionCount) {
        super(domainName, domainHash);
        this.currentSessionStartTime = currentSessionStartTime;
        this.sessionCount = sessionCount;
    }

    protected GaUtmbCookie() {
    }

    public GaUtmbCookie(String domainName, String domainHash) {
        super(domainName, domainHash);
    }

    public String toCookieString() {
        return this.getDomainHash() + "." + this.sessionCount + "." + "10." + this.currentSessionStartTime;
    }

    public void setFromCookieString(String cookieString) throws IllegalArgumentException {
        String[] dotParts = cookieString.split("\\.");
        if (dotParts.length != 4) {
            throw new IllegalArgumentException("Could not parse '" + cookieString + "' into four dot-separated parts");
        }
        this.domainHash = dotParts[0];
        this.sessionCount = UrlAndHashUtils.parseAsLong(dotParts[1]);
        this.currentSessionStartTime = UrlAndHashUtils.parseAsLong(dotParts[3]);
    }
}

