package com.calpano.common.shared.util;

import java.util.ArrayList;
import java.util.List;

import org.xydra.annotations.RunsInGWT;


/**
 * Super-sourced version
 * 
 * @author xamde
 * 
 * @param <T>
 */
@RunsInGWT(true)
public class QueueGwtEmul<T> implements Queue<T> {
	
	private List<T> q;
	
	/**
	 * @param size initial buffer size, if applicable
	 */
	public QueueGwtEmul(int size) {
		this.q = new ArrayList<T>(size);
	}
	
	@Override
	public void enqueue(T element) {
		this.q.add(element);
	}
	
	@Override
	public boolean isEmpty() {
		return this.q.isEmpty();
	}
	
	@Override
	public T peek() {
		return this.q.get(0);
	}
	
	@Override
	public T poll() {
		T head = peek();
		this.q.remove(0);
		return head;
	}
	
}
