<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xhtml="http://www.w3.org/1999/xhtml" version="1.0">

	<xsl:output encoding="utf-8" method="html"
		omit-xml-declaration="yes" indent="yes" />

	<xsl:template match="log">
		<!-- <xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html&gt;</xsl:text> -->
		<html>
			<head>
				<meta charset="utf-8" />
				<title>View in Firefox only (Chrome, XSLT, Security, Problem)!</title>
				<link rel="stylesheet" href="main.css" type="text/css" />
			</head>
			<body>
				<xsl:apply-templates select="./*" />
			</body>
		</html>
	</xsl:template>

	<!-- filtering interesting elements -->

	<xsl:template match="debug">
		<div class="line dir-out">
			<div class="debug">
				<xsl:apply-templates select="." mode="cell" />
			</div>
		</div>
	</xsl:template>

<!-- 	<xsl:template match="*[@role='IgnoreAndPassThrough']"> -->
<!-- 		<div class="line dir-out"> -->
<!-- 			<div class="debug"> -->
<!-- 				IgnoreAndPassThrough -->
<!-- 				<xsl:apply-templates select="." mode="cell" /> -->
<!-- 				<xsl:call-template name="atts" /> -->
<!-- 			</div> -->
<!-- 		</div> -->
<!-- 	</xsl:template> -->

	<!-- <xsl:template match="*[@role='ProcessAndPassAllThrough']"> -->
	<!-- <div class="line dir-out"> -->
	<!-- <div class="debug"> -->
	<!-- ProcessAndPassAllThrough <xsl:apply-templates select="." mode="cell" 
		/> -->
	<!-- </div> -->
	<!-- </div> -->
	<!-- </xsl:template> -->

	<!-- <xsl:template match="*[@role='Stop']"> -->
	<!-- <div class="line dir-out"> -->
	<!-- <div class="debug"> -->
	<!-- Stop <xsl:apply-templates select="." mode="cell" /> -->
	<!-- </div> -->
	<!-- </div> -->
	<!-- </xsl:template> -->

	<xsl:template match="*">
		<div
			class="line dir-{@dir} role-{@role} type-{@type} kind-{@kind} action-{@action}"
			data-type="{@type}">
			<div
				class="token dir-{@dir} role-{@role} type-{@type} kind-{@kind} action-{@action}"
				data-type="{@type}">
				<xsl:apply-templates select="." mode="cell" />
				<xsl:call-template name="atts" />
			</div>
		</div>
	</xsl:template>

	<xsl:template name="atts">
		<span class="atts">
			<xsl:text>[</xsl:text>
			<xsl:for-each select="@*">

				<xsl:choose>
					<xsl:when
						test="name(.) = 'dir' or name(.) = 'role' or name(.) = 'type' or name(.) = 'kind' or name(.) = 'action'"></xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="name(.)" />
						<xsl:text>='</xsl:text>
						<xsl:value-of select="." />
						<xsl:text>' </xsl:text>
					</xsl:otherwise>
				</xsl:choose>

			</xsl:for-each>
			<xsl:text>]</xsl:text>
		</span>
	</xsl:template>

	<xsl:template mode="cell" match="End">
		<xsl:text>&lt;/</xsl:text>
		<xsl:value-of select="@type" />
		<xsl:if test="@chars">
			'
			<xsl:value-of select="@chars" />
			'
		</xsl:if>
		<xsl:text>&gt;</xsl:text>
	</xsl:template>

	<xsl:template mode="cell" match="Start">
		<xsl:text>&lt;</xsl:text>
		<xsl:value-of select="@type" />
		<xsl:if test="@chars">
			'
			<xsl:value-of select="@chars" />
			'
		</xsl:if>
		<xsl:text>&gt;</xsl:text>
	</xsl:template>


	<xsl:template mode="cell" match="Content">
		<xsl:value-of select="text()" />
	</xsl:template>

</xsl:stylesheet>