package com.calpano.common.client;

import org.xydra.conf.IConfig;
import org.xydra.conf.IConfigProvider;
import org.xydra.conf.annotations.ConfDoc;
import org.xydra.conf.annotations.ConfType;

import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;

public class ConfParamsCalpanoCommonClient implements IConfigProvider {

	@ConfType(Boolean.class)
	@ConfDoc("pure client side debug mode")
	public static final String ClientDebugMode = "clientDebugMode";

	@Override
	public void configureDefaults(final IConfig conf) {
		conf.setDefault(ClientDebugMode, false, true);
		conf.setInstance(EventBus.class, new SimpleEventBus());
	}

}
