package com.calpano.common.client.storage;

import org.xydra.annotations.CanBeNull;

/**
 * A storage bound to a single key in localStorage.
 *
 * @param <T>
 */
public abstract class SingleKeyStorage<T> extends GenericStorage<T> {

	/**
	 * Defines the key under which the value is stored.
	 *
	 * @return String the key;
	 *
	 */
	public abstract String getKey();

	/**
	 * @return stored value in deserialised form or null of not found, null was
	 *         stored or local storage is not supported at all.
	 */
	public @CanBeNull T get() {
		return super.get(getKey());
	}

	/**
	 * Just does nothing if localStorage not supported.
	 *
	 * @param object
	 */
	public void store(final T object) {
		super.store(getKey(), object);
	}

	public void remove() {
		super.removeItem(getKey());
	}
}
