package com.calpano.common.client.util;

import org.xydra.annotations.RunsInGWT;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.google.gwt.user.client.Window;

/**
 * Access to HTML5 PushState
 *
 * @author xamde
 */
@RunsInGWT(true)
public class PushState {

	private static final Logger log = LoggerFactory.getLogger(PushState.class);

	private static final boolean SUPPORT = isSupported();

	/**
	 * patched for tests in PushStatePatcher#isSupported()
	 *
	 * @return ...
	 */
	public static native boolean isSupported()
	/*-{

	try {
	  if($wnd.history.replaceState)
	    return true;
	  else
	    return false;
	} catch (e) {
	    return false;
	}

	}-*/;

	static {
		log.info("On this browser HTML5 history.replaceState is " + (SUPPORT ? "well" : "not")
				+ " supported");
	}

	/**
	 * Check for HTML5 support and fall back to page reload if desired
	 *
	 * @param data
	 * @param title
	 * @param url
	 * @param reloadPageIfPushStateUnsupported
	 *            if no HTML5 support is there for pushState, this parameter
	 *            controls the fall-back behaviour. If true, page is reloaded.
	 *            If false, just do nothing.
	 */
	public void pushState(final String data, final String title, final String url,
			final boolean reloadPageIfPushStateUnsupported) {
		if (SUPPORT) {
			pushState(data, title, url);
		} else if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
		// else: do nothing
	}

	/**
	 * Check for HTML5 support and fall back to page reload if desired
	 *
	 * @param title
	 * @param url
	 * @param reloadPageIfPushStateUnsupported
	 *            if no HTML5 support is there for pushState, this parameter
	 *            controls the fall-back behaviour. If true, page is reloaded.
	 *            If false, just do nothing.
	 */
	public void pushStateNoData(final String title, final String url, final boolean reloadPageIfPushStateUnsupported) {
		if (SUPPORT) {
			pushStateNoData(title, url);
		} else if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
		// else: do nothing
		// FIXME PUSHSTATE Polyfill ..
	}

	/**
	 * Check for HTML5 support and fall back to page reload if desired
	 *
	 * @param url
	 * @param reloadPageIfPushStateUnsupported
	 *            if no HTML5 support is there for pushState, this parameter
	 *            controls the fall-back behaviour. If true, page is reloaded.
	 *            If false, just do nothing.
	 */
	public void pushStateNoData(final String url, final boolean reloadPageIfPushStateUnsupported) {
		if (SUPPORT) {
			pushStateNoData(url);
		} else if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
		// else: do nothing
		// FIXME PUSHSTATE Polyfill ..
	}

	/**
	 * Check for HTML5 support and fall back to page reload if desired
	 *
	 * @param url
	 * @param reloadPageIfPushStateUnsupported
	 *            if no HTML5 support is there for pushState, this parameter
	 *            controls the fall-back behaviour. If true, page is reloaded.
	 *            If false, just do nothing.
	 */
	public void replaceStateNoData(final String url, final boolean reloadPageIfPushStateUnsupported) {
		if (SUPPORT) {
			replaceStateNoData(url);
		} else if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
		// else: do nothing
		// FIXME PUSHSTATE Polyfill ..
	}

	/**
	 * Check for HTML5 support and fall back to page reload if desired
	 *
	 * @param data
	 * @param title
	 * @param url
	 * @param reloadPageIfPushStateUnsupported
	 *            if no HTML5 support is there for pushState, this parameter
	 *            controls the fall-back behaviour. If true, page is reloaded.
	 *            If false, just do nothing.
	 */
	public void replaceState(final String data, final String title, final String url,
			final boolean reloadPageIfPushStateUnsupported) {
		if (SUPPORT) {
			replaceState(data, title, url);
		} else if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
		// else: do nothing
		// FIXME PUSHSTATE Polyfill ..
	}

	/**
	 * Check for HTML5 support and fall back to page reload if desired
	 *
	 * @param title
	 * @param url
	 * @param reloadPageIfPushStateUnsupported
	 *            if no HTML5 support is there for pushState, this parameter
	 *            controls the fall-back behaviour. If true, page is reloaded.
	 *            If false, just do nothing.
	 */
	public void replaceStateNoData(final String title, final String url,
			final boolean reloadPageIfPushStateUnsupported) {
		if (SUPPORT) {
			replaceStateNoData(title, url);
		} else if (reloadPageIfPushStateUnsupported) {
			setUrl(url);
		}
		// else: do nothing
		// FIXME PUSHSTATE Polyfill ..
	}

	/**
	 * Execute native HTML5 pushState which fails if browser does not support
	 * it.
	 *
	 * @param data
	 * @param title
	 * @param url
	 */
	public native void pushState(String data, String title, String url)
	/*-{
	  $wnd.history.pushState(data, title, url);
	}-*/;

	/**
	 * Execute native HTML5 pushState which fails if browser does not support
	 * it.
	 *
	 * @param title
	 * @param url
	 */
	public native void pushStateNoData(String title, String url)
	/*-{
	  $wnd.history.pushState(null, title, url);
	}-*/;

	/**
	 * Execute native HTML5 pushState which fails if browser does not support
	 * it.
	 *
	 * @param url
	 */
	public native void pushStateNoData(String url)
	/*-{
	  $wnd.history.pushState(null, $doc.title, url);
	}-*/;

	/**
	 * Execute native HTML5 pushState which fails if browser does not support
	 * it.
	 *
	 * @param url
	 */
	public native void replaceStateNoData(String url)
	/*-{
	  $wnd.history.replaceState(null, $doc.title, url);
	}-*/;

	/**
	 * Execute native HTML5 pushState which fails if browser does not support
	 * it.
	 *
	 * @param data
	 * @param title
	 * @param url
	 */
	public native void replaceState(String data, String title, String url)
	/*-{
	  $wnd.history.replaceState(data, title, url);
	}-*/;

	/**
	 * Execute native HTML5 pushState which fails if browser does not support
	 * it.
	 *
	 * @param title
	 * @param url
	 */
	public native void replaceStateNoData(String title, String url)
	/*-{
	  $wnd.history.replaceState(null, title, url);
	}-*/;

	/**
	 * Simply loads the given URL, unless we are already on it. Looses all
	 * internal GWT state as page is reloaded.
	 *
	 * @param url
	 */
	private static void setUrl(final String url) {
		final String currentLocation = Window.Location.getHref();
		if (!currentLocation.equals(url)) {
			Window.Location.assign(url);
		} else {
			log.info("We are already on '" + currentLocation + "' so no need to reload.");
		}
	}

}
