package com.calpano.common.client.view;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * A widget representing an UL-Element // from turbomanage
 *
 */
public class UnorderedListWidget extends ComplexPanel {

	public UnorderedListWidget() {
		setElement(Document.get().createULElement());
	}

	public void setId(final String id) {
		// Set an attribute common to all tags
		getElement().setId(id);
	}

	public void setDir(final String dir) {
		// Set an attribute specific to this tag
		((UListElement) getElement().cast()).setDir(dir);
	}

	@Override
	public void add(final Widget w) {
		// ComplexPanel requires the two-arg add() method
		final Element element = getElement();
		super.add(w, element);
	}

	@Override
	public void insert(final Widget child, final Element container, final int beforeIndex, final boolean domInsert) {
		super.insert(child, container, beforeIndex, domInsert);
	}

}
