package com.calpano.common.client.view.forms;

import org.xydra.annotations.Feature;
import org.xydra.annotations.NeverNull;

import com.calpano.common.client.view.forms.activation.HasActivationHandlers;
import com.calpano.common.client.view.forms.activation.HasDeactivationHandlers;
import com.calpano.common.client.view.forms.impl.Html5FormPanel;
import com.calpano.common.client.view.forms.locking.ILockable;
import com.calpano.common.client.view.forms.placeholder.IPlaceholderSupport;
import com.calpano.common.client.view.forms.validation.HasInvaliationHandlers;
import com.calpano.common.client.view.forms.validation.HasValidationHandlers;
import com.calpano.common.shared.validation.IStringValidator;
import com.calpano.common.shared.validation.ValidationMessage;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBoxBase;

/**
 * A collection of HTML5 features for text inputs that are supported by
 * implementations of this interface.
 *
 * Supported features:
 *
 * <h3>Placeholder</h3> Pure GWT implementation that work ins any browser. Can
 * be used via UIBinder by setting 'placeholder' attribute.
 *
 * Implementations overwrite {@link #getText()} and #getValue to return only
 * user-typed text -a nd not the faked placeholder.
 *
 * On <em>any change, after typing any character</em>, a
 * {@link ValueChangeEvent} is fired. GWT normally only fires it if the TextBox
 * looses focus.
 *
 *
 * <h3>Validation</h3> Supported attributes are 'required' and 'type=email'.
 * Other types are silently ignored.
 *
 * Listens to {@link ValueChangeEvent} and performs validation.
 *
 * <h3>Showing validation warnings</h3> Listens as a IValidityChangeHandler and
 * shows warnings by changing CSS classes and adding tooltip-popups.
 *
 * @author xamde
 */
public interface IHtml5TextInput extends ILockable, IBelongsToHtml5Form, HasActivationHandlers,
		HasDeactivationHandlers, HasValidationHandlers, HasInvaliationHandlers, IPlaceholderSupport {

	/**
	 * @return the managed widget as a {@link TextBoxBase}
	 */
	TextBoxBase getTextBoxBase();

	/**
	 * Validation of input elements in HTML5. If true, the form can only be
	 * submitted if a value is given.
	 *
	 * @param value
	 */
	@Feature("validation")
	void setRequired(boolean value);

	@Feature("validation")
	boolean isRequired();

	/**
	 * Add a custom validator to be used if the built-in rules consider the
	 * result to be valid. The custom validator can perform stricter checks.
	 *
	 * All validators are used in defined order to compute the final
	 * {@link ValidationMessage}.
	 *
	 * @param order
	 *            the lower the number, the earlier the validator is called.
	 *            This allows to order them for efficiency.
	 * @param validator
	 */
	@Feature("validation")
	void addValidator(Integer order, IStringValidator validator);

	/**
	 * Used by {@link Html5FormPanel} to check validation status of inputs.
	 *
	 * @return the current {@link ValidationMessage} @NeverNull
	 */
	@Feature("validation")
	@NeverNull
	ValidationMessage computeValidation();

	/**
	 * @return the HTML5 input type, such as 'email'
	 */
	@Feature("validation")
	String getType();

	@Feature("placeholder")
	String getText();

	/** Reset lock state, validation state, placeholder state */
	void reset();

	/**
	 * Check user input and show validation warnings. From now on, watch user
	 * input changes and show a warning whenever the content turns wrong and
	 * hide the warning whenever the content is ok.
	 */
	@Feature("validation")
	void activateValidationWarnings();

	/**
	 * @return true if this input field is currently showing suggestions. This
	 *         has e.g. implications what the ENTER key does.
	 */
	boolean isShowingSuggestions();

	/**
	 * @param oracle
	 *            @NeverNull
	 */
	void suggestValuesFrom(SuggestOracle oracle);

}
