package com.calpano.common.client.view.forms;

import org.xydra.annotations.NeverNull;

import com.calpano.common.shared.validation.IValidator;
import com.calpano.common.shared.validation.ValidationMessage;

/**
 * Can compute the validity status of a given widget (Presenter-level)
 *
 * Implementations should provide meaningful equals() and hashCode().
 */
public interface IViewValidator extends IValidator<IHtml5TextInput> {

	/**
	 * @param widget
	 *            @NeverNull
	 * @return the {@link ValidationMessage} that results from inspecting the
	 *         given widget
	 */
	@Override
	ValidationMessage computeValidation(@NeverNull IHtml5TextInput widget);

}
