package com.calpano.common.client.view.hover;

import com.calpano.common.shared.util.CommonAppState.Is;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.web.bindery.event.shared.HandlerRegistration;

/**
 * A widget that implements this interface provides registration for
 * {@link HoverHandler} instances.
 */
public interface HasHoverHandlers extends IsWidget {
	/**
	 * Adds a {@link HoverEvent} handler.
	 *
	 * @param handler
	 * @return {@link HandlerRegistration} used to remove this handler
	 */
	HandlerRegistration addHoverHandler(HoverHandler handler);

	Is getLastHoverFired();

	void setLastHoverFired(Is yes);

}
