package com.calpano.common.shared.mail;

import org.xydra.sharedutils.URLUtils;

/**
 * Helper to generate the correctly encoded mailto:-URLs
 *
 * @author xamde
 */
public class MailtoUrlUtil {

	/**
	 * For (X)HTML: Replace '&' with '&amp;'
	 *
	 * @param recipient
	 * @param subject
	 * @param body
	 * @return the full url like 'mailto:john@doe.com?subject=Welcome+Dear+John'
	 */
	public static String toMailtoUrl(final String recipient, final String subject, final String body) {
		final StringBuffer buf = new StringBuffer();
		buf.append("mailto:").append(spacePercent20Encode(recipient)).append("?subject=");
		buf.append(URLUtils.encode(subject));
		buf.append("&amp;body=");
		buf.append(URLUtils.encode(body));
		String s = buf.toString();
		s = s.replace("+", "%20");
		/* http://www.boutell.com/newfaq/misc/urllength.html */
		assert s.length() <= 2000 : "IE cannot handle urls longer than 2000 charrs";
		return s;
	}

	public static String spacePercent20Encode(final String raw) {
		return raw.replace(" ", "%20");
	}

}
