package com.calpano.common.shared.user.base;

import java.util.ArrayList;
import java.util.List;

import org.xydra.annotations.CanBeNull;
import org.xydra.annotations.NeverNull;
import org.xydra.annotations.RunsInGWT;
import org.xydra.index.query.Pair;

import com.calpano.common.shared.mail.EmailUtils;
import com.calpano.common.shared.user.INameEmail;

@RunsInGWT(true)
public class NameEmailUtils {

	public static String getNameOrEmail(@CanBeNull final String name, @NeverNull final String email) {
		if (name == null) {
			return email;
		} else {
			return name;
		}
	}

	public static String getNameAndEmail(final String name, final String email) {
		if (name == null) {
			return email;
		} else {
			return name + " (" + email + ")";
		}
	}

	/**
	 * @param addresses
	 *            are comma-separated
	 * @return a list of parsed addresses
	 * @throws IllegalArgumentException
	 *             if input could not be parsed
	 */
	public static List<INameEmail> parseAddresses(final String addresses) throws IllegalArgumentException {
		final List<INameEmail> list = new ArrayList<INameEmail>();
		final String[] sep = addresses.split(",");
		for (final String s : sep) {
			list.add(parseAddress(s));
		}
		return list;

	}

	/**
	 * @param address
	 *            in format '"Jon Doe" <johnl@doemail.com>' or just
	 *            'john@doemail.com' or as bad as '=?utf-8?q?max_v=c3=b6lkel?=
	 *            <max.voelkel@example.com>' '
	 * @return a parsed
	 * @throws IllegalArgumentException
	 *             if syntax was violated
	 */
	public static INameEmail parseAddress(final String address) throws IllegalArgumentException {
		final Pair<String, String> nameEmail = EmailUtils.parseAddress(address);
		return new SimpleNameEmail(nameEmail.getFirst(), nameEmail.getSecond());
	}

	public static void main(final String[] args) {
		final String s = "=?utf-8?q?Max_V=c3=b6lkel?= <max.voelkel@calpano.com>";
		System.out.println(s);
		System.out.println(parseAddress(s).getNameAndEmail());
	}
}
