package com.calpano.common.shared.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

import org.xydra.annotations.LicenseApache;

/**
 * Small stuff for using java Collections.
 *
 * @author xamde
 *
 */
public class CollectionUtils {

	public static Collection<String> split(final String str, final String separator) {
		final ArrayList<String> strings = new ArrayList<String>();
		if (str.contains(separator)) {
			final String[] splittedString = str.split(separator);
			strings.addAll(Arrays.asList(splittedString));
		} else {
			if (!str.equals(EMPTY)) {
				strings.add(str);
			}
		}

		return strings;
	}

	public static final String EMPTY = "";

	/*
	 * Adapted from org.apache.commons.lang.StringUtils
	 *
	 * Licensed to the Apache Software Foundation (ASF) under one or more
	 * contributor license agreements. See the NOTICE file distributed with this
	 * work for additional information regarding copyright ownership. The ASF
	 * licenses this file to You under the Apache License, Version 2.0 (the
	 * "License"); you may not use this file except in compliance with the
	 * License. You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
	 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
	 * License for the specific language governing permissions and limitations
	 * under the License.
	 */
	/**
	 * <p>
	 * Joins the elements of the provided <code>Iterator</code> into a single
	 * String containing the provided elements.
	 * </p>
	 *
	 * <p>
	 * No delimiter is added before or after the list. A <code>null</code>
	 * separator is the same as an empty String ("").
	 * </p>
	 *
	 * @param iterator the <code>Iterator</code> of values to join together, may
	 *            be null
	 * @param separator the separator character to use, null treated as ""
	 * @return the joined String, <code>null</code> if null iterator input
	 */
	@LicenseApache(project = "Apache Commons Lang", notice = "NOTICE.apache-commons-lang.txt")
	public static String join(final Iterator<String> iterator, final String separator) {

		// handle null, zero and one elements before building a buffer
		if (iterator == null) {
			return null;
		}
		if (!iterator.hasNext()) {
			return EMPTY;
		}
		final String first = iterator.next();
		if (!iterator.hasNext()) {
			return first;
		}
		final StringBuilder strBuilder = new StringBuilder();

		if (first != null) {
			strBuilder.append(first);
		}

		while (iterator.hasNext()) {
			if (separator != null) {
				strBuilder.append(separator);
			}
			strBuilder.append(iterator.next());

		}
		return strBuilder.toString();
	}

	/*
	 * from org.apache.commons.lang.StringUtils
	 *
	 * Licensed to the Apache Software Foundation (ASF) under one or more
	 * contributor license agreements. See the NOTICE file distributed with this
	 * work for additional information regarding copyright ownership. The ASF
	 * licenses this file to You under the Apache License, Version 2.0 (the
	 * "License"); you may not use this file except in compliance with the
	 * License. You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
	 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
	 * License for the specific language governing permissions and limitations
	 * under the License.
	 */
	/**
	 * <p>
	 * Joins the elements of the provided <code>Collection</code> into a single
	 * String containing the provided elements.
	 * </p>
	 *
	 * <p>
	 * No delimiter is added before or after the list. A <code>null</code>
	 * separator is the same as an empty String ("").
	 * </p>
	 *
	 * @param collection the <code>Collection</code> of values to join together,
	 *            may be null
	 * @param separator the separator character to use, null treated as ""
	 * @return the joined String, <code>null</code> if null iterator input
	 * @since 2.3
	 */
	public static String join(final Collection<String> collection, final String separator) {
		if (collection == null) {
			return null;
		}
		return join(collection.iterator(), separator);
	}

	public static String toString(final Enumeration<?> e) {
		final StringBuffer buf = new StringBuffer();
		while (e.hasMoreElements()) {
			final Object o = e.nextElement();
			buf.append("" + o + ",");
		}
		return buf.toString();
	}

	public static String toString(final Set<?> set) {
		final StringBuffer buf = new StringBuffer("{");
		for (final Object o : set) {
			buf.append("" + o + ",");
		}
		buf.append("}");
		return buf.toString();
	}

	public static String toString(final List<?> list) {
		final StringBuffer buf = new StringBuffer("]");
		for (final Object o : list) {
			buf.append("" + o + ",");
		}
		buf.append("]");
		return buf.toString();
	}

	public static <T> Iterator<T> emptyIterator() {
		return new Iterator<T>() {

			@Override
			public boolean hasNext() {
				return false;
			}

			@Override
			public T next() {
				throw new NoSuchElementException();
			}

			@Override
			public void remove() {
			}

		};
	}

	/**
	 * Great for nesting of maps
	 *
	 * @param keyPrefix never null
	 * @param map can be null
	 * @return a map with all keys being prefixed by the common prefix, never
	 *         null
	 */
	public static Map<String, String> prefixKeys(final String keyPrefix, final Map<String, String> map) {
		final Map<String, String> result = new HashMap<String, String>();
		if (map != null) {
			for (final Map.Entry<String, String> entry : map.entrySet()) {
				result.put(keyPrefix + entry.getKey(), entry.getValue());
			}
		}
		return result;
	}

	public static Map<String, String> prefixKeys_listMap(final String keyPrefix,
			final Map<String, List<String>> listmap) {
		final Map<String, String> result = new HashMap<String, String>();
		if (listmap != null) {
			for (final Map.Entry<String, List<String>> entry : listmap.entrySet()) {
				final ArrayList<String> list = new ArrayList<String>();
				list.addAll(entry.getValue());
				result.put(keyPrefix + entry.getKey(), list.toString());
			}
		}
		return result;
	}

	public static <T> Set<T> toSet(final Iterator<T> it) {
		final HashSet<T> set = new HashSet<T>();
		while (it.hasNext()) {
			final T t = it.next();
			set.add(t);
		}
		return set;
	}

}
