package com.calpano.common.shared.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.xydra.annotations.RunsInGWT;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.DebugUtils;

/**
 * Can render exceptions as nicely readable HTML.
 *
 * Can raise some classic exceptions to test how your app handles them.
 *
 * @author xamde
 */
@RunsInGWT(true)
public class SharedExceptionUtils_GwtEmul {

	private static final Logger log = LoggerFactory.getLogger(SharedExceptionUtils_GwtEmul.class);

	/**
	 * See also {@link DebugUtils#dumpStacktrace()}
	 *
	 * @return the stack trace as a multi-line StringBuffer
	 */
	public static StringBuffer getStacktraceAsString() {
		try {
			throw new RuntimeException("CALLER");
		} catch (final Exception e) {
			final StringWriter sw = new StringWriter();
			final PrintWriter pw = new PrintWriter(sw);
			e.printStackTrace(pw);
			pw.flush();
			pw.close();
			sw.flush();
			return sw.getBuffer();
		}
	}

	/**
	 * @param class1
	 * @return format
	 *         'com.calpano.common.shared.util.SharedExceptionUtils_GwtEmul.main(SharedExceptionUtils_GwtEmul.java:83)'
	 */
	public static String getCallerAsEclipseHyperlink(final Class<?> ... skipClazzes) {
		try {
			throw new RuntimeException("CALLER");
		} catch (final Exception e) {
			final StringWriter sw = new StringWriter();
			final PrintWriter pw = new PrintWriter(sw);
			e.printStackTrace(pw);
			pw.flush();
			pw.close();
			sw.flush();

			final StringReader sr = new StringReader(sw.getBuffer().toString());
			final BufferedReader br = new BufferedReader(sr);

			try {
				/* java.lang.RuntimeException: CALLER */
				br.readLine();

				/* at com.calpano.common.shared.util.SharedExceptionUtils_GwtEmul.getCallerAsEclipseHyperlink(
				 * SharedExceptionUtils_GwtEmul.java:49) */
				br.readLine();

				/* at
				 * com.calpano.common.shared.util.SharedExceptionUtils_GwtEmul.main(SharedExceptionUtils_GwtEmul.java:
				 * 75) */
				String line = br.readLine();

				while(containsClass(line, skipClazzes)) {
					line = br.readLine();
				}

				return line.substring(line.indexOf("at ") + "at ".length());
			} catch (final IOException e2) {
				throw new RuntimeException(e2);
			}
		}

	}

	private static boolean containsClass(final String line, final Class<?> ... skipClazzes) {
		if(skipClazzes == null) {
			return false;
		}
		for( final Class<?> skipClazz : skipClazzes) {
			if(line.contains(skipClazz.getSimpleName()+".java:")) {
				return true;
			}
		}

		return false;
	}

	public static void main(final String[] args) {
		System.out.println("CALLER " + getCallerAsEclipseHyperlink());
	}

	private static List<String> linesAsList(final String s) {
		final StringReader sr = new StringReader(s);
		final BufferedReader br = new BufferedReader(sr);
		final List<String> list = new ArrayList<String>();
		try {
			for (String line = br.readLine(); line != null; line = br.readLine()) {
				list.add(line);
			}
		} catch (final IOException e) {
			assert false;
		}
		return list;
	}

	/**
	 * Assume a and b come from the same program and have a common caller hierarchy. Display the stack traces in three
	 * parts: Just A, just B, and the common ancestor of both A and B.
	 *
	 * @param aname headline for a
	 * @param a a stack trace with newlines in it
	 * @param bname headline for b
	 * @param b another stack trace with newlines in it
	 * @param linesToSkip how many lines in the beginning to skip
	 */
	public static void dumpWhereStacktracesAreDifferent(final String aname, final String a, final String bname,
			final String b, final int linesToSkip) {
		List<String> alist = linesAsList(a);
		alist = alist.subList(linesToSkip, alist.size());
		List<String> blist = linesAsList(b);
		blist = blist.subList(linesToSkip, blist.size());
		final List<String> common = new ArrayList<String>();
		/* list have not always the same length */
		String commonLine = "none";
		while (alist.size() > 0 && blist.size() > 0
				&& alist.get(alist.size() - 1).equals(blist.get(blist.size() - 1))) {
			commonLine = alist.get(alist.size() - 1);
			common.add(0, commonLine);
			alist = alist.subList(0, alist.size() - 1);
			blist = blist.subList(0, blist.size() - 1);
		}
		log.warn(" " + aname + " ==== ");
		for (final String s : alist) {
			log.warn(s);
		}
		log.warn(" " + bname + " ==== ");
		for (final String s : blist) {
			log.warn(s);
		}
		log.warn(" Common start of both stack traces ==== ");
		for (final String s : common) {
			log.warn(s);
		}
	}
}
