package com.calpano.common.shared.xydrautils;

import org.xydra.annotations.Template;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XWritableModel;

/**
 * Persistence is based on an {@link XWritableModel}
 *
 * @author xamde
 */
public interface IBasedOnXReadableModel extends IBasedOnXReadableEntity {

	/**
	 * @return the XID of the underlying {@link XWritableModel}
	 */
	@Override
	@Template("Unique ID")
	XId getId();

	/**
	 * @return the {@link XAddress} of the underlying {@link XWritableModel}
	 */
	@Override
	XAddress getAddress();

	/**
	 * @return the underlying {@link XReadableModel} itself
	 */
	XReadableModel getXWritableModel();

}
