package com.calpano.common.shared.xydrautils;

import org.xydra.annotations.Template;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XWritableModel;

/**
 * Persistence is based on an {@link XWritableModel}
 *
 * @author xamde
 */
public interface IBasedOnXWritableModel extends IBasedOnXReadableModel, IBasedOnXWritableEntity {

	/**
	 * @return the XID of the underlying {@link XWritableModel}
	 */
	@Template("Unique ID")
	@Override
	XId getId();

	/**
	 * @return the {@link XAddress} of the underlying {@link XWritableModel}
	 */
	@Override
	XAddress getAddress();

	/**
	 * @return the underlying {@link XWritableModel} itself
	 */
	@Override
	XWritableModel getXWritableModel();

	/**
	 * @return the XID of the actor registered for change events
	 */
	@Override
	XId getActorId();

}
