package com.calpano.common.shared.xydrautils.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.xydra.base.BaseRuntime;
import org.xydra.base.XAddress;
import org.xydra.base.value.XAddressListValue;

public class XAddressListFieldProperty extends
		ExtensibleFieldProperty<List<XAddress>, XAddressListValue> {

	public XAddressListFieldProperty(final String fieldIdString) {
		super(fieldIdString, new Converter<List<XAddress>, XAddressListValue>() {

			@Override
			public List<XAddress> toJavaType(final XAddressListValue xydraType) {
				if (xydraType == null) {
					return new ArrayList<XAddress>(0);
				} else {
					final XAddress[] contents = xydraType.contents();
					final ArrayList<XAddress> result = new ArrayList<XAddress>(contents.length);
					result.addAll(Arrays.asList(contents));
					return result;
				}
			}

			@Override
			public XAddressListValue toXydraValue(final List<XAddress> anyType) {
				return BaseRuntime.getValueFactory().createAddressListValue(anyType);
			}
		});
	}

}
