package com.calpano.common.shared.xydrautils.field;

import java.util.SortedSet;
import java.util.TreeSet;

import org.xydra.base.BaseRuntime;
import org.xydra.base.XAddress;
import org.xydra.base.value.XAddressSortedSetValue;

public class XAddressSortedSetFieldProperty extends
		ExtensibleFieldProperty<SortedSet<XAddress>, XAddressSortedSetValue> {

	public XAddressSortedSetFieldProperty(final String fieldIdString) {
		super(fieldIdString, new Converter<SortedSet<XAddress>, XAddressSortedSetValue>() {

			@Override
			public SortedSet<XAddress> toJavaType(final XAddressSortedSetValue xydraType) {
				if (xydraType == null) {
					return new TreeSet<XAddress>();
				} else {
					return xydraType.toSortedSet();
				}
			}

			@Override
			public XAddressSortedSetValue toXydraValue(final SortedSet<XAddress> anyType) {
				return BaseRuntime.getValueFactory().createAddressSortedSetValue(anyType);
			}
		});
	}

}
