package de.xam.texthtml.css;

import com.google.common.base.Joiner;

/**
 * Transforms stuff into valid CSS expressions
 *
 * @author xamde
 */
public class CssTool {

	/**
	 * @param b
	 * @param cssClass
	 * @param ruleBody
	 */
	public static void appendRule(final StringBuilder b, final String cssClass, final String ruleBody) {
		assert cssClass != null;
		assert ruleBody != null;

		b.append(".");
		b.append(cssClass);
		b.append(" {\n  ");
		b.append(ruleBody);
		b.append("\n}\n");
	}

	public static void main(final String[] args) {
		final StringBuilder b = new StringBuilder();
		appendRule(b, "foo", "color: red;");
		System.out.println(b.toString());
	}

	/**
	 * @param someCssClasses
	 * @CanBeNull
	 * @param moreCssClasses
	 * @CanBeNull
	 * @return @NeverNull
	 */
	public static String toCssClassString(final String[] someCssClasses, final String... moreCssClasses) {
		final StringBuilder b = new StringBuilder();
		final Joiner joiner = Joiner.on(" ");
		if (someCssClasses != null) {
			joiner.appendTo(b, someCssClasses);
		}
		if (moreCssClasses != null) {
			joiner.appendTo(b, moreCssClasses);
		}

		return b.toString();
	}

	public static String toCssClassString(final Iterable<?> set) {
		final StringBuilder b = new StringBuilder();
		final Joiner joiner = Joiner.on(" ");
		if (set != null) {
			joiner.appendTo(b, set);
		}

		return b.toString();
	}

}
