package de.xam.textsearch.compare;

import java.util.Comparator;

import de.xam.textsearch.Match;
import de.xam.textsearch.spi.IContentResolver;

public class PrefixMatchFirstComparator<V> implements Comparator<Match<V>> {

	private final String prefix;

	public PrefixMatchFirstComparator(final IContentResolver<V> contentResolver, final String prefix) {
		super();
		this.contentResolver = contentResolver;
		this.prefix = prefix;
	}

	private final IContentResolver<V> contentResolver;

	@Override
	public int compare(final Match<V> a, final Match<V> b) {

		final boolean matchA = this.contentResolver.getContentAsStringForTextIndexing(a.getValue())
				.toLowerCase().startsWith(this.prefix.toLowerCase());
		final boolean matchB = this.contentResolver.getContentAsStringForTextIndexing(b.getValue())
				.toLowerCase().startsWith(this.prefix.toLowerCase());

		if (matchA) {
			if (matchB) {
				return 0;
			} else {
				return -1;
			}
		} else {
			if (matchB) {
				return +1;
			} else {
				return 0;
			}
		}
	}

}
