package de.xam.textsearch.compare;

import java.util.Comparator;

import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import de.xam.textsearch.Match;
import de.xam.textsearch.spi.IContentResolver;

/**
 * Comparing matches is done by comparing the projected string content of the
 * value objects
 *
 * @param <V>
 */
public class ShortestFirstMatchComparator<V> implements Comparator<Match<V>> {

	public ShortestFirstMatchComparator(final IContentResolver<V> contentResolver) {
		this.contentResolver = contentResolver;
	}

	private final IContentResolver<V> contentResolver;

	@Override
	public int compare(final Match<V> a, final Match<V> b) {
		return compare_static(a, b, this.contentResolver);
	}

	private static final Logger log = LoggerFactory.getLogger(ShortestFirstMatchComparator.class);

	/**
	 * Can deal with null-content for a match
	 *
	 * @param a
	 * @param b
	 * @param contentResolver
	 * @return
	 */
	public static <T> int compare_static(final Match<T> a, final Match<T> b, final IContentResolver<T> contentResolver) {
		final String aContent = contentResolver.getContentAsStringForTextIndexing(a.getValue());
		final String bContent = contentResolver.getContentAsStringForTextIndexing(b.getValue());

		if (aContent == null) {
			log.warn("No content for match A " + a);
		}
		if (bContent == null) {
			log.warn("No content for match B " + b);
		}

		if (aContent == null) {
			if (bContent == null) {
				return 0;
			} else {
				return 1;
			}
		} else {
			if (bContent == null) {
				return -1;
			} else {
				return aContent.length() - bContent.length();
			}
		}
	}

}
