package de.xam.textsearch.text;

import java.io.Serializable;
import java.util.List;

import com.google.gwt.thirdparty.guava.common.base.Joiner;

import de.xam.textsearch.query.OrQuery;

public class TextQuery<V> extends OrQuery<V>implements ITextQuery<V>, Serializable {

	private static final long serialVersionUID = 1L;

	private final List<String> fragments;

	private final String phrase;

	private final List<String> words;

	/**
	 * @param phrase @NeverNull
	 * @param words @NeverNull
	 * @param fragments @NeverNull
	 */
	public TextQuery(final String phrase, final List<String> words, final List<String> fragments) {
		super();
		assert phrase !=null;
		assert words != null;
		assert fragments !=null;
		this.phrase = phrase;
		this.words = words;
		this.fragments = fragments;
	}

	@Override
	public List<String> getFragments() {
		return this.fragments;
	}

	@Override
	public String getPhrase() {
		return this.phrase;
	}

	@Override
	public List<String> getWords() {
		return this.words;
	}

	@Override
	public String toString() {
		final StringBuilder b = new StringBuilder();
		b.append("TextQuery ");
		b.append(super.toString());

		b.append(" phrase='");
		b.append(getPhrase());
		b.append("'");

		b.append(" words='");
		Joiner.on("', '").appendTo(b, getWords());
		b.append("'");

		b.append(" fragments='");
		Joiner.on("', '").appendTo(b, getFragments());
		b.append("'");

		return b.toString();
	}

}
