package de.xam.triplerules;

/**
 * Bind a number of variables to values, and one variable to an iterator.
 *
 * A IRuleConditionBinding is shared while executing a rule and binding more and
 * more variables with each explored {@link ITriplePattern}.
 *
 * @author xamde
 * @param <K>
 * @param <L>
 * @param <M>
 */
public interface IRuleConditionBinding<K, L, M> {

	/**
	 * @param variable
	 * @return @CanBeNull if not bound
	 */
	<E> E boundValue(IVariable<E> variable);

	/**
	 * @param i
	 * @return the value to which the variable at index i is bound; @CanBeNull
	 *         if not bound
	 */
	<E> E boundValue(int i);

	/**
	 * @param variable
	 * @return true iff the given variable is already bound
	 */
	<E> boolean isBound(IVariable<E> variable);

	/**
	 * @param i
	 * @return true iff the denoted variable is already bound
	 */
	<E> boolean isBound(int i);

	/**
	 * @return number of bound variables
	 */
	int size();

	/**
	 * @return the number of possible bindings = total number of distinct
	 *         variables in the rule
	 */
	int capacity();

}
