package de.xam.triplerules;

/**
 * A rule has a condition and when the condition is matched in a given triple
 * index/base, the triples defined in action are added. Variables can be used in
 * conditions and actions.
 *
 * @author xamde
 *
 * @param <K>
 * @param <L>
 * @param <M>
 */
public interface ITripleRule<K, L, M> {

	/**
	 * AND semantics
	 *
	 * @return the set of patterns to be matched
	 */
	IRuleCondition<K, L, M> condition();

	/**
	 * @return the set of triples to be added;
	 */
	IRuleAction<K, L, M> action();

	/**
	 * @return an empty string, dump to Xydra Logging as log.info(..)
	 */
	String dump();

	/**
	 * @param variableName
	 * @return the internal id number for the given variable name
	 */
	int translateNameToId(String variableName);

	/**
     *
     */
	void compile();

	/**
	 * @return the number of distinct variables used in this rule
	 */
	int varCount();

	/**
	 * @return a debug label for this rule
	 */
	String label();

	/**
	 * @param variableIdNumber
	 * @return the human-readable variable name for the given internal variable
	 *         id number
	 */
	String translateIdToName(int variableIdNumber);

}
