package de.xam.triplerules;

import org.xydra.index.query.Constraint;

/**
 * All variables must have a name
 *
 * @author xamde
 *
 * @param <E>
 */
public interface IVariable<E> extends Constraint<E> {

	/**
	 * @return the variable name, to be able to refer to it @NeverNull
	 */
	String name();

	/**
	 * Requires {@link #compile(ITripleRule)} before.
	 *
	 * @return id assigned by {@link #compile(ITripleRule)} or default value
	 */
	int id();

	/**
	 * Translates variables name to id and initializes 'id'.
	 *
	 * @param rule
	 */
	void compile(ITripleRule<?, ?, ?> rule);

	/**
	 * Helps debugging
	 *
	 * @param binding
	 * @return ...
	 */
	String toString(IRuleConditionBinding<?, ?, ?> binding);

}
