package de.xam.triplerules.impl;

import org.xydra.index.query.EqualsConstraint;

import de.xam.triplerules.IRuleConditionBinding;
import de.xam.triplerules.ITripleRule;
import de.xam.triplerules.IVariable;

/**
 * A constraint that matches any object.
 *
 * @param <K>
 *            key type
 */
public class EqualsVariable<K> extends EqualsConstraint<K> implements IVariable<K> {

	private final String name;

	public EqualsVariable(final String name, final K expect) {
		super(expect);
		assert name != null;
		this.name = name;
	}

	@Override
	public String name() {
		return this.name;
	}

	@Override
	public String toString() {
		return "'" + this.expect + "'";
	}

	@Override
	public int hashCode() {
		return this.name.hashCode() + this.expect.hashCode();
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof EqualsVariable
				&& ((EqualsVariable<?>) other).expect.equals(this.expect)
				&& ((EqualsVariable<?>) other).name.equals(this.name);
	}

	private final int id = -1;

	@Override
	public int id() {
		return this.id;
	}

	@Override
	public void compile(final ITripleRule<?, ?, ?> rule) {
	}

	@Override
	public String toString(final IRuleConditionBinding<?, ?, ?> binding) {
		return toString();
	}
}
