package de.xam.triplerules.impl;

import de.xam.triplerules.IRuleCondition;
import de.xam.triplerules.ITriplePattern;

/**
 * If a {@link IRuleCondition} has several {@link ITriplePattern} with unbound
 * variables, then this cost estimator can help to choose which pattern to match
 * first.
 *
 * @author xamde
 *
 * @param <K>
 * @param <L>
 * @param <M>
 */
public interface ICostEstimator<K, L, M> {

	/**
	 * @param pattern
	 * @param binding
	 *            some bound variables
	 * @return estimated costs in range 0 = no costs and all variables defined.
	 *         Returns > 0..infinity = undefined variables, real costs
	 */
	double estimatedCosts(ITriplePattern<K, L, M> pattern, ConditionBinding<K, L, M> binding);

	/**
	 * @param pattern
	 * @return estimated costs in range 0 = no costs, variables defined; > 0
	 *         ..infinity = undefined variables, real costs
	 */
	double estimatedCosts(ITriplePattern<K, L, M> pattern);
}
