package de.xam.triplerules.impl;

import java.util.HashSet;
import java.util.Set;

import com.google.common.collect.ImmutableSet;

import de.xam.triplerules.IReadonlyTriplePatternSet;
import de.xam.triplerules.ITriplePattern;

public class ReadonlyTriplePatternSet<K, L, M> implements IReadonlyTriplePatternSet<K, L, M> {

	public static <K, L, M> IReadonlyTriplePatternSet<K, L, M> matchAlways() {
		return new IReadonlyTriplePatternSet<K, L, M>() {

			@Override
			public Set<ITriplePattern<K, L, M>> patterns() {
				final ITriplePattern<K, L, M> pattern = TriplePattern.matchAlways();
				return ImmutableSet.of(pattern);
			}
		};
	}

	protected Set<ITriplePattern<K, L, M>> patterns = new HashSet<ITriplePattern<K, L, M>>();

	@Override
	public Set<ITriplePattern<K, L, M>> patterns() {
		return this.patterns;
	}

}
