package de.xam.triplerules.impl;

import java.util.Iterator;

import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import de.xam.triplerules.IRuleCondition;
import de.xam.triplerules.IRuleConditionBinding;
import de.xam.triplerules.ITriplePattern;

/**
 * Also known as a "graph pattern"
 *
 * @author xamde
 * @param <K>
 * @param <L>
 * @param <M>
 */
public class RuleCondition<K, L, M> extends ReadonlyTriplePatternSet<K, L, M> implements
		IRuleCondition<K, L, M> {

	private static final Logger log = LoggerFactory.getLogger(RuleCondition.class);

	@Override
	public RuleCondition<K, L, M> addCondition(final ITriplePattern<K, L, M> conditionPattern) {
		this.patterns.add(conditionPattern);
		return this;
	}

	public void dump() {
		log.info(this.toString());
	}

	@Override
	public String toString() {
		return toString(null);
	}

	@Override
	public String toString(final IRuleConditionBinding<K, L, M> binding) {
		final StringBuffer buf = new StringBuffer("IF ");

		final Iterator<ITriplePattern<K, L, M>> it = patterns().iterator();
		while (it.hasNext()) {
			final ITriplePattern<K, L, M> pattern = it.next();
			buf.append(pattern.toString(binding));
			if (it.hasNext()) {
				buf.append(" AND ");
			}
		}
		return buf.toString();
	}

}
