package de.xam.triplerules.impl;

import org.xydra.index.query.Wildcard;

import de.xam.triplerules.IRuleConditionBinding;
import de.xam.triplerules.ITripleRule;
import de.xam.triplerules.IVariable;

/**
 * A constraint that matches any object.
 *
 * @param <K> key type
 */
public class WildcardVariable<K> extends Wildcard<K>implements IVariable<K> {

	private final String name;

	/**
	 * @param name
	 * @NeverNull
	 */
	public WildcardVariable(final String name) {
		super();
		assert name != null;
		this.name = name;
	}

	@Override
	public String name() {
		return this.name;
	}

	@Override
	public String toString() {
		return "?" + (this.id == -1 ? "" : this.id + "/") + this.name;
	}

	@Override
	public String toString(final IRuleConditionBinding<?, ?, ?> binding) {
		if (binding == null) {
			return toString();
		}

		final Object o = binding.boundValue(id());
		if (o == null) {
			return toString();
		} else {
			return "?" + this.id + "/" + this.name + "='" + o.toString() + "'";
		}
	}

	@Override
	public int hashCode() {
		return this.name.hashCode();
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof WildcardVariable && ((WildcardVariable<?>) other).name.equals(this.name);
	}

	private int id = -1;

	@Override
	public int id() {
		return this.id;
	}

	@Override
	public void compile(final ITripleRule<?, ?, ?> rule) {
		this.id = rule.translateNameToId(name());
	}

}
